import httpRequest from '@/utils/axios'

// 获取视频列表
export function getVideoList(params: { tab: string; status?: string; authorized?: string; classification?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/resource/v1/resource/video/list', { params })
}

// 创建视频
export function createVideo(data: { name: string; source: string; classification: string; knowledge_points: string; cover: string; source_id: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/create', data)
}

// 获取封面列表
export function getCoverList() {
  return httpRequest.get('/api/resource/v1/util/get-cover-list')
}

// 获取视频详情
export function getVideoDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/video/view', { params })
}

// 更新视频
export function updateVideo(data: { id: string; name: string; classification: string; knowledge_points?: string; cover?: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/update', data)
}

// 部门共享
export function setDepartment(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/set-department', data)
}

// 平台共享
export function setPlatform(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/set-platform', data)
}

// 上下线
export function setStatus(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/set-status', data)
}

// 更改负责人
export function setBelong(data: { id: string; belong_operator: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/set-belong', data)
}

// 获取视频详情
export function getVideoPpt(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/video/get-ppt', { params })
}

// 创建课件
export function createPpt(data: { id: string; ppts: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/create-ppt', data)
}

// 编辑课件
export function updatePpt(data: { id: string; ppt_id: string, name: string, point: string, url: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/update-ppt', data)
}

// 编辑课件
export function deletePpt(data: { id: string; ppt_id: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/delete-ppt', data)
}
