import type { Component } from 'vue'

export interface IMenuItem {
  tag?: string
  name: string
  path: string
  icon?: Component
  children?: IMenuItem[]
}

// 用户信息
export interface UserType {
  id: string
  mobile: string
  name: string
  email: string
  username: string
  avatar: string
}

// 项目信息
export interface ProjectType {
  id: string
  tab: string
  name: string
}

// 机构信息
export interface OrganizationType {
  id: string
  name: string
  contact_name: string
  contact_information: string
  validity_date: string
  is_valid: 1 | 2
}

// 角色信息
export interface RoleType {
  id: string
  name: string
  desc: string
}

// 权限信息
export interface PermissionType {
  desc: string
  effect_uris: string
  id: string
  name: string
  parent_id: string
  system_tag: number
  type: number
  tag: string
}

// 课程信息
export interface CourseType {
  auth_view: boolean
  belong_operator: string
  belong_operator_name: string
  big: string
  classification: string
  classification_name: string
  cover: string
  created_operator: string
  created_operator_name: string
  created_time: string
  credit: string
  department_public: string
  elective_type: string
  elective_type_name: string
  id: string
  name: string
  online_type: string
  online_type_name: string
  organ_id: string
  organ_id_name: string
  platform_public: string
  project_id: string
  project_id_name: string
  small: string
  status: string
  status_name: string
  updated_operator: string
  updated_operator_name: string
  updated_time: string
}
