/**
 * 文件下载
 * @param {string} fileUrl 文件下载地址
 * @param {string} fileName 文件名
 * @returns {null}
 */
export function funDownload(fileUrl: any, fileName: any) {
  // console.log(fileUrl)
  const elink = document.createElement('a') // 创建一个a标签
  elink.download = fileName // 设置a标签的下载属性
  elink.style.display = 'none' // 将a标签设置为隐藏
  elink.href = fileUrl // 把之前处理好的地址赋给a标签的href
  document.body.appendChild(elink) // 将a标签添加到body中
  elink.click() // 执行a标签的点击方法
  // URL.revokeObjectURL(elink.href) // 下载完成释放URL 对象
  document.body.removeChild(elink) // 移除a标签
}
/**
 * 分割字符串，取得尾部
 * @param {string} str 字符串
 * @param {string} split 分割符
 * @returns {string}
 */
export function splitStrLast(str: any, split: any) {
  const fileNameArr = str.split(split)
  const last = fileNameArr[fileNameArr.length - 1]
  return last
}
