import httpRequest from '@/utils/axios'

// 获取分类列表
export function getCategoryList(params: { type: string }) {
  return httpRequest.get('/api/resource/v1/backend/category/list', { params })
}
// 新建分类
export function createCategory(data: {
  category_name: string
  depth?: string
  status: string
  need_pass: string
  parent_id: string
}) {
  return httpRequest.post('/api/resource/v1/backend/category/create', data)
}
// 编辑分类
export function updateCategory(data: {
  id: string
  category_name: string
  depth?: string
  status: string
  need_pass: string
  parent_id: string
}) {
  return httpRequest.post('/api/resource/v1/backend/category/update', data)
}
// 删除分类
export function delCategory(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/backend/category/delete', data)
}
// 移动分类
export function moveCategory(data: { id: string; brother_id: string; type: string }) {
  return httpRequest.post('/api/resource/v1/backend/category/drag', data)
}
