import httpRequest from '@/utils/axios'

// 讲师搜索
export function searchLecturer(params: { name: string; 'per-page'?: string; }) {
  return httpRequest.get('/api/resource/v1/course/course/search-lecturer', { params })
}

// 直播搜索
export function searchLive(params: { name: string; 'per-page'?: string; }) {
  return httpRequest.get('/api/resource/v1/course/course/search-live', { params })
}

// 试卷搜索
export function searchExam(data: { nonce: string; timestamp: string; signature: string, paper_title: string; limit: string; is_all: number; project_prefix: string; }) {
  return httpRequest.post('/api/qbs/api/v1/question-papers/search', data)
}

// 新建课件
export function createCourse(data: any) {
  return httpRequest.post('/api/resource/v1/course/course/create', data)
}

// 更新课件
export function updateCourse(data: any) {
  return httpRequest.post('/api/resource/v1/course/course/update', data)
}

// 获取封面列表
export function getCoverList() {
  return httpRequest.get('/api/resource/v1/util/get-cover-list')
}

// 获取课程详情
export function getCourseDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/course/course/view', { params })
}

// 上下线
export function setStatus(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/course/course/set-status', data)
}

// 更新视频
export function updateVideo(data: { id: string; name: string; classification: string; knowledge_points?: string; cover?: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/update', data)
}

// 部门共享
export function setDepartment(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/set-department', data)
}

// 平台共享
export function setPlatform(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/set-platform', data)
}

// 更改负责人
export function setBelong(data: { id: string; belong_operator: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/set-belong', data)
}

// 获取视频详情
export function getVideoPpt(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/video/get-ppt', { params })
}

// 创建课件
export function createPpt(data: { id: string; ppts: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/create-ppt', data)
}

// 编辑课件
export function updatePpt(data: { id: string; ppt_id: string, name: string, point: string, url: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/update-ppt', data)
}

// 编辑课件
export function deletePpt(data: { id: string; ppt_id: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/delete-ppt', data)
}
