import { defineStore } from 'pinia'
import { getMapList } from '@/api/base'

interface IMapState {
  id: string
  key: string
  name: string
  remark: string
  values: IValuesList[]
}

interface IValuesList {
  data_dictionary_id: string
  id: string
  label: string
  remark: string
  sort: string
  value: string
}
export const useMapStore = defineStore({
  id: 'map',
  state: () => {
    return {
      mapList: [] as IMapState | any
    }
  },
  getters: {},
  actions: {
    async getMapList() {
      const res = await getMapList()
      this.mapList = res.data
    }
  }
})

useMapStore().getMapList()
