import httpRequest from '@/utils/axios'

// 获取班级列表
export function getClassList(params?: { name?: string; organ_id?: string; page?: string; 'per-page'?: string }) {
  return httpRequest.get('/api/resource/v1/learning/class/list', { params })
}
// 添加班级
export function addClass(data: {
  name?: string
  organ_id?: string
  start_year?: string
  code: string
  specialty_id: string
  teacher_id: string
}) {
  return httpRequest.post('/api/resource/v1/learning/class/create', data)
}
// 更新班级
export function updateClass(data: {
  id: string
  name: string
  organ_id: string
  start_year: string
  code: string
  specialty_id: string
  teacher_id: string
}) {
  return httpRequest.post('/api/resource/v1/learning/class/update', data)
}
// 添加班级
export function getClassDetail(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/learning/class/view', { params })
}
// 搜索班主任
export function searchTeacher(params: { organ_id: string; page?: string; 'per-page'?: string }) {
  return httpRequest.get('/api/resource/v1/learning/class/search-teacher', { params })
}

// 获取专业列表
export function getProList(params?: { name?: string; page?: string; 'per-page'?: string }) {
  return httpRequest.get('/api/resource/v1/backend/specialty/list', { params })
}
// 获取班级学员列表
export function getClassStuList(params?: { class_id?: string; name?: string; page?: string; 'per-page'?: string }) {
  return httpRequest.get('/api/resource/v1/learning/class/students', { params })
}
// 获取班级学期列表
export function getClassSemList(params?: { class_id?: string; page?: string; 'per-page'?: string }) {
  return httpRequest.get('/api/resource/v1/learning/class/semesters', { params })
}
// 关联学生-获取学生列表
export function getRelationClassStuList(params?: {
  class_id?: string
  name?: string
  page?: string
  'per-page'?: string
}) {
  return httpRequest.get('/api/resource/v1/learning/class/add-students', { params })
}
// 关联学期-获取学期列表
export function getRelationSemList(params?: { class_id: string; page?: string; 'per-page'?: string }) {
  return httpRequest.get('/api/resource/v1/learning/class/add-semesters', { params })
}
// 关联学生-关联/移除学生
export function relationClassStu(data?: { class_id: string; students_id: string; type: string }) {
  return httpRequest.post('/api/resource/v1/learning/class/add-students  ', data)
}
// 关联学生-关联/移除学生
export function relationClassSem(data?: { class_id: string; semesters_id: string; type: string }) {
  return httpRequest.post('/api/resource/v1/learning/class/add-semesters', data)
}

// // 导入学生
export function importClass(data: { file: any }) {
  return httpRequest.post('/api/resource/v1/learning/class/import', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}
