import { getClassList, getProList } from '../api'

// 专业列表
export function useSpecialtyList() {
  const items = ref([])
  const params = reactive({ name: '' })

  const fetchList = async () => {
    const { data } = await getProList({ ...params, 'per-page': '100', sort: 'name' })
    items.value = data.list
  }
  onMounted(fetchList)
  return { items, params, fetchList }
}

// 班级列表
export function useClassList() {
  const items = ref([])
  const params = reactive({ organ_id: '', specialty_id: '' })

  const fetchList = async () => {
    const { data } = await getClassList({ ...params, 'per-page': '100', sort: 'name' })
    items.value = data.list
  }

  watch(params, fetchList)
  onMounted(fetchList)
  return { items, params, fetchList }
}
