import { createRouter, createWebHistory } from 'vue-router'
import { useUserStore } from '@/stores/user'

const router = createRouter({
  history: createWebHistory(),
  routes: [{ path: '/:pathMatch(.*)*', redirect: '/resource/dashboard' }]
})

router.beforeEach(async (to, from, next) => {
  const user = useUserStore()
  if (!user.isLogin) {
    try {
      await user.getUser()
    } catch (e) {
      console.error(e)
    }
    user.isLogin ? next() : (location.href = `${import.meta.env.VITE_LOGIN_URL}?rd=${encodeURIComponent(location.href)}`)
    return
  }
  next()
})

export default router
