import httpRequest from '@/utils/axios'

// 获取视频列表
export function getSuggestionList(params?: {
  sso_id?: string
  created_time_start?: string
  created_time_end?: string
  page?: string
  ['per-page']?: string
}) {
  return httpRequest.get('/api/resource/v1/backend/suggestion/list', { params })
}
// 用户检索
export function getUserList(params?: { q: string }) {
  return httpRequest.get('/api/resource/v1/backend/suggestion/search-user', { params })
}
// 投诉建议详情
export function getSuggestionDetail(params?: { id: string }) {
  return httpRequest.get('/api/resource/v1/backend/suggestion/view', { params })
}
// 回复投诉建议
export function replySuggestion(data: { id: string; reply: string }) {
  return httpRequest.post('/api/resource/v1/backend/suggestion/update', data)
}
