import type { IMenuItem } from '@/types'
import { VideoCamera, Suitcase, Collection, Files, Monitor, Edit, User, Filter, Coordinate, Notebook, Picture } from '@element-plus/icons-vue'
export const menus: IMenuItem[] = [
  {
    name: '资源管理',
    path: '/resource',
    children: [
      {
        icon: VideoCamera,
        name: '视频',
        path: '/resource/video'
      },
      { icon: Suitcase, name: '课件', path: '/resource/courseware' },
      {
        icon: Collection,
        name: '教案',
        path: '/resource/lessonplan'
      },
      {
        icon: Files,
        name: '其他资料',
        path: '/resource/other'
      }
      // {
      //   name: '题库',
      //   path: '/resource/question'
      // },
      // {
      //   name: '试卷',
      //   path: '/resource/exam'
      // }
    ]
  },
  {
    name: '课程管理',
    path: '/course',
    children: [
      {
        icon: Monitor,
        name: '我的课程',
        path: '/course/my'
      },
      {
        icon: Edit,
        name: '新建课程',
        path: '/course/create'
      }
    ]
  },
  {
    name: '后台管理',
    path: '/admin',
    children: [
      {
        icon: User,
        name: '讲师管理',
        path: '/admin/teacher'
      },
      {
        icon: Filter,
        name: '类别管理',
        path: '/admin/category'
      },
      {
        icon: Coordinate,
        name: '资源审核管理',
        path: '/admin/audit'
      }
    ]
  },
  {
    name: '系统管理',
    path: '/system',
    children: [
      {
        icon: Notebook,
        name: '数据字典',
        path: '/system/dictionary'
      },
      {
        icon: Picture,
        name: '封面管理',
        path: '/system/cover'
      }
    ]
  }
]
