import httpRequest from '@/utils/axios'

// 获取视频列表
export function getVideoList(params: { tab: string; status?: string; authorized?: string; classification?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/resource/v1/resource/video/list', { params })
}

// 创建视频
export function createVideo(data: { name: string; source: string; classification: string; knowledge_points: string; cover: string; source_id: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/create', data)
}

// 获取分类列表
export function getCategoryList(params: { type: string; category_name?: string }) {
  return httpRequest.get('/api/resource/v1/backend/category/list', { params })
}

// 获取封面列表
export function getCoverList() {
  return httpRequest.get('/api/resource/v1/util/get-cover-list')
}

// 更新视频
export function updateVideo(data: { id: string; course_name: string; cover_page: string; type: string; weight?: string }) {
  return httpRequest.post('/api/resource/backend/video/update', data)
}

// 获取视频详情
export function getVideo(params: { id: string }) {
  return httpRequest.get('/api/resource/backend/video/view', { params })
}

// 获取项目列表
export function getProjectList(params: { organization_id: string }) {
  return httpRequest.get('/api/resource/v1/util/members', { params })
}
