import httpRequest from '@/utils/axios'

// 获取封面列表
export function getCoverList(params?: { type?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/resource/v1/backend/cover/list', { params })
}
// 创建封面
export function createCover(data?: { title?: string; status?: number; type?: number; url?: number }) {
  return httpRequest.post('/api/resource/v1/backend/cover/create', data)
}
// 更新封面
export function updateCover(data?: { title?: string; status?: number; type?: number; url?: number }) {
  return httpRequest.post('/api/resource/v1/backend/cover/update', data)
}
// 删除封面
export function deleteCover(data: { id: any }) {
  return httpRequest.post('/api/resource/v1/backend/cover/delete', data)
}

// 获取公共字典列表
export function getMapList() {
  return httpRequest.get('/api/resource/v1/util/get-data-dictionary-list')
}
