import httpRequest from '@/utils/axios'

// 获取视频列表
export function getVideoList(params?: { type?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/resource/backend/video/index', { params })
}
// 获取字典列表
export function getDictionaryList(params?: {
  name?: string
  key?: string
  status?: string
  created_time_start?: string
  created_time_end?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/resource/v1/backend/data-dictionary/list', { params })
}
// 新增字典
export function createDictionary(data: {
  name: string
  key: string
  status?: string
  remark?: string
  can_edit?: string
}) {
  return httpRequest.post('/api/resource/v1/backend/data-dictionary/create', data)
}
// 更新字典
export function updateDictionary(data: {
  id: string
  name: string
  key: string
  status?: string
  remark?: string
  can_edit?: string
}) {
  return httpRequest.post('/api/resource/v1/backend/data-dictionary/update', data)
}
// 删除字典
export function delDictionary(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/backend/data-dictionary/delete', data)
}
// 获取字典的值的列表
export function getDictionaryItemList(params?: { data_dictionary_id: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/resource/v1/backend/data-dictionary/value-list', { params })
}
// 新增字典的值
export function createDictionaryItem(data: {
  data_dictionary_id: string
  label: string
  value: string
  sort: string
  remark: string
  can_edit: string
  status: string
}) {
  return httpRequest.post('/api/resource/v1/backend/data-dictionary/value-create', data)
}
// 更新字典的值
export function updateDictionaryItem(data: {
  id: any
  data_dictionary_id: string
  label: string
  value: string
  sort: string
  remark: string
  can_edit: string
  status: string
}) {
  return httpRequest.post('/api/resource/v1/backend/data-dictionary/value-update', data)
}
// 删除字典的值
export function delDictionaryItem(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/backend/data-dictionary/value-delete', data)
}
