// json to array
export const json2Array = function (data, isValueToNumber = true) {
  return Object.keys(data).map(value => ({ label: data[value], value: isValueToNumber ? parseInt(value) : value }))
}

// 组卷模式
export const paperType = {
  1: '选题组卷',
  2: '自动组卷',
  3: '自由组卷'
}
// 组卷模式列表
export const paperTypeList = json2Array(paperType)

// 试题类型
export const questionType = {
  1: '单选题',
  2: '多选题',
  3: '问答题',
  5: '案例题',
  6: '判断题',
  7: '实操题',
  8: '情景题'
}
// 试题类型列表
export const questionTypeList = json2Array(questionType, false)

// 试题难度
export const questionDifficulty = {
  1: '易',
  2: '中',
  3: '难',
  0: '无'
}
// 试题难度列表
export const questionDifficultyList = json2Array(questionDifficulty, false)
