import httpRequest from '@/utils/axios'

// 讲师搜索
export function searchLecturer(params: { name: string; 'per-page'?: string }) {
  return httpRequest.get('/api/resource/v1/course/course/search-lecturer', { params })
}

// 直播搜索
export function searchLive(params: { name: string; 'per-page'?: string }) {
  return httpRequest.get('/api/resource/v1/course/course/search-live', { params })
}

// 试卷搜索
export function searchExam(params: {
  project_tag: string
  id?: string
  paper_title?: string
  permission: string
  paper_type?: string
  paper_labels?: string
  paper_category?: string
  paper_categories?: string
  page?: string
  limit?: string
}) {
  return httpRequest.get(`/api/qbs/admin/v2/question-papers/${params.project_tag}`, { params })
}

// 新建课件
export function createCourse(data: any) {
  return httpRequest.post('/api/resource/v1/course/course/create', data)
}

// 更新课件
export function updateCourse(data: any) {
  return httpRequest.post('/api/resource/v1/course/course/update', data)
}

// 获取封面列表
export function getCoverList() {
  return httpRequest.get('/api/resource/v1/util/get-cover-list')
}

// 获取课程详情
export function getCourseDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/course/course/view', { params })
}

// 上下线
export function setStatus(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/course/course/set-status', data)
}

// 更新视频
export function updateVideo(data: {
  id: string
  name: string
  classification: string
  knowledge_points?: string
  cover?: string
}) {
  return httpRequest.post('/api/resource/v1/resource/video/update', data)
}

// 部门共享
export function setDepartment(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/set-department', data)
}

// 平台共享
export function setPlatform(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/set-platform', data)
}

// 更改负责人
export function setBelong(data: { id: string; belong_operator: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/set-belong', data)
}

// 获取视频详情
export function getVideoPpt(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/video/get-ppt', { params })
}

// 创建课件
export function createPpt(data: { id: string; ppts: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/create-ppt', data)
}

// 编辑课件
export function updatePpt(data: { id: string; ppt_id: string; name: string; point: string; url: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/update-ppt', data)
}

// 编辑课件
export function deletePpt(data: { id: string; ppt_id: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/delete-ppt', data)
}

// 获取视频列表
export function getVideoList(params: {
  course_id: string
  tab: string
  status?: string
  authorized?: string
  classification?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/resource/v1/course/course/search-video', { params })
}
// 获取视频列表
export function getCourseList(params: {
  tab: string
  name?: string
  authorized?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/resource/v1/course/course/list', { params })
}
// 获取课件列表
export function getCourseListSearch(params: {
  tab: string
  name?: string
  authorized?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/resource/v1/course/course/search-courseware', { params })
}

// 获取课程统计
export function getCourseStatistics() {
  return httpRequest.get('/api/resource/v1/course/course/statistics')
}

// 获取教案列表
export function getLessonList(params?: {
  tab: string
  status?: string
  authorized?: string
  classification?: string
  page?: number
  ['per-page']?: number
}) {
  return httpRequest.get('/api/resource/v1/course/course/search-lesson-plan', { params })
}
// 获取其他资料列表
export function getOtherList(params?: {
  tab: string
  status?: string
  authorized?: string
  classification?: string
  page?: number
  ['per-page']?: number
}) {
  return httpRequest.get('/api/resource/v1/course/course/search-other-information', { params })
}

// 获取视频详情
export function getVideoDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/video/view', { params })
}
// 获取课件详情
export function getCourseWareDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/courseware/view', { params })
}
// 获取教案详情
export function getLessonDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/lesson-plan/view', { params })
}
// 获取其他资料详情
export function getOtherDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/other-information/view', { params })
}
// 章节结构调整
export function dragChapterList(data: { course_id: string; id: string; brother_id: string; type: string }) {
  return httpRequest.post('/api/resource/v1/course/course/drag', data)
}
// 获取章节
export function getCharacter(params: { course_id: string; type: string }) {
  return httpRequest.get('/api/resource/v1/course/course/chapters', { params })
}
// 新建章节
export function createCharacter(data: {
  course_id: string
  resource_type: string
  name: string
  parent_id?: string
  resource_id?: string
}) {
  return httpRequest.post('/api/resource/v1/course/course/create-chapter', data)
}
// 章节修改
export function editCharacter(data: { id: string; course_id: string; name: string; resource_id: string }) {
  return httpRequest.post('/api/resource/v1/course/course/update-chapter', data)
}
// 章节删除
export function delCharacter(data: { id: string; course_id: string }) {
  return httpRequest.post('/api/resource/v1/course/course/delete-chapter', data)
}
// 直播列表
export function getLiveList(params: { name: string; page?: number; ['page_size']?: number }) {
  return httpRequest.get('/api/resource/v1/course/course/search-live', { params })
}

