import { getProjectList } from '@/api/base'

export function useProjectList(id?: string) {
  const list = ref([])
  const members = ref([])
  const departmentList = ref([])
  getProjectList({ organization_id: id || '' }).then((res: any) => {
    list.value = res.data.departments
    members.value = res.data.members
    departmentList.value = res.data.departments.reduce((a: any, b:any) => {
      if (b.organizations.length) {
        a.push(b.organizations)
      }
      return a.flat(Infinity)
    }, [])
  })
  return { list, members, departmentList }
}