import httpRequest from '@/utils/axios'

// 获取大作业列表
export function getWorkList(params?: {
  course_id: string
  title?: string
  class_id?: string
  page?: string
  page_size?: string
}) {
  return httpRequest.get('/api/resource/v1/teaching/job/list', { params })
}
// 搜索条件
export function getSearchList(params?: { type: string; search_id?: string }) {
  return httpRequest.get('/api/resource/v1/teaching/job/search-list', { params })
}
// 大作业详情
export function getWorkDetail(params?: { id: string }) {
  return httpRequest.get('/api/resource/v1/teaching/job/view', { params })
}
//大作业批改
export function updateWork(data: { id: string; score: string }) {
  return httpRequest.post('/api/resource/v1/teaching/job/update', data)
}
