import type { IMenuItem } from '@/types'
import {
  FolderOpened,
  ToiletPaper,
  VideoCamera,
  Suitcase,
  Collection,
  Files,
  Monitor,
  Edit,
  User,
  Filter,
  Coordinate,
  Notebook,
  Picture,
  UserFilled,
  Promotion,
  School,
  Guide,
  QuestionFilled,
  EditPen,
  DataAnalysis
} from '@element-plus/icons-vue'
export const menus: IMenuItem[] = [
  {
    tag: 'v1-resource',
    name: '资源管理',
    path: '/resource',
    children: [
      {
        tag: 'v1-resource-video-list',
        icon: VideoCamera,
        name: '视频',
        path: '/resource/video'
      },
      {
        tag: 'v1-resource-courseware-list',
        icon: Suitcase,
        name: '课件',
        path: '/resource/courseware'
      },
      {
        tag: 'v1-resource-lesson-plan-list',
        icon: FolderOpened,
        name: '教案',
        path: '/resource/lessonplan'
      },
      {
        tag: 'v1-resource-other-information-list',
        icon: Files,
        name: '其他资料',
        path: '/resource/other'
      },
      {
        icon: Collection,
        name: '题库管理',
        path: 'https://qa-center.ezijing.com/question/list'
      },
      {
        icon: ToiletPaper,
        name: '试卷管理',
        path: 'https://qa-center.ezijing.com/paper/list'
      }
    ]
  },
  {
    tag: 'v1-course',
    name: '课程管理',
    path: '/course',
    children: [
      {
        tag: 'v1-course-list',
        icon: Monitor,
        name: '我的课程',
        path: '/course/my'
      },
      {
        tag: 'v1-course-create',
        icon: Edit,
        name: '新建课程',
        path: '/course/update-course'
      }
    ]
  },
  {
    tag: 'v1-backend',
    name: '基础信息',
    path: '/admin',
    children: [
      {
        tag: 'v1-backend-lecturer-list',
        icon: UserFilled,
        name: '讲师管理',
        path: '/admin/teacher'
      },
      {
        tag: 'v1-backend-lecturer-list',
        icon: School,
        name: '教工用户管理',
        path: '/admin/staff'
      },
      {
        tag: 'v1-backend-lecturer-list',
        icon: User,
        name: '学生管理',
        path: '/admin/student'
      },
      {
        tag: 'v1-backend-lecturer-list',
        icon: Promotion,
        name: '专业管理',
        path: '/admin/pro'
      },
      {
        tag: 'v1-backend-lecturer-list',
        icon: School,
        name: '班级管理',
        path: '/admin/class'
      },
      {
        tag: 'v1-backend-lecturer-list',
        icon: Guide,
        name: '学期管理',
        path: '/admin/semester'
      },

      {
        tag: 'v1-backend-category-list',
        icon: Filter,
        name: '类别管理',
        path: '/admin/category'
      },
      {
        icon: Coordinate,
        name: '资源审核管理',
        path: '/admin/audit'
      }
    ]
  },
  {
    tag: 'v1-backend',
    name: '系统管理',
    path: '/system',
    children: [
      {
        tag: 'v1-backend-data-dictionary-list',
        icon: Notebook,
        name: '数据字典',
        path: '/system/dictionary'
      },
      {
        tag: 'v1-backend-cover-list',
        icon: Picture,
        name: '封面管理',
        path: '/system/cover'
      }
    ]
  },
  {
    tag: 'v1-backend',
    name: '教学管理',
    path: '/teach',
    children: [
      {
        tag: 'v1-backend-lecturer-list',
        icon: QuestionFilled,
        name: '问答管理',
        path: '/teach/qa'
      },
      {
        tag: 'v1-backend-lecturer-list',
        icon: EditPen,
        name: '批改试卷',
        path: '/teach/exam'
      },
      {
        tag: 'v1-backend-lecturer-list',
        icon: DataAnalysis,
        name: '数据画像与分析',
        path: '/teach/exam'
      }
    ]
  }
]
