import httpRequest from '@/utils/axios'

// 获取学生列表
export function getProList(params?: { type?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/psp/backend/video/index', { params })
}

/**
 * 获取试卷详情
 */
export function getPaperDetails(params?: { exam_id: string; student_id: string }) {
  return httpRequest.get('/api/exam/v1/exam/sheet-detail', { params })
}
/**
 * 批改试卷
 */
export function submitPaper(data?: {
  sheet_id: string
  question_item_id: string
  question_id: string
  score: string
  comment: string
}) {
  return httpRequest.post('/api/exam/v1/exam/submit-sheet', data)
}
