import httpRequest from '@/utils/axios'

// 获取课件列表
export function getCourseList(params: {
  tab: string
  status?: string
  authorized?: string
  classification?: string
  page?: number
  ['per-page']?: number
}) {
  return httpRequest.get('/api/resource/v1/resource/courseware/list', { params })
}

// 创建
export function createCourse(data: {
  url: string
  name: string
  source: string
  classification: string
  knowledge_points: string
}) {
  return httpRequest.post('/api/resource/v1/resource/courseware/create', data)
}

// 获取分类列表
export function getCategoryList(params: { type: string; category_name?: string }) {
  return httpRequest.get('/api/resource/v1/backend/category/list', { params })
}

// 更新课件
export function updateCourse(data: {
  id: string
  url: string
  name: string
  source: string
  classification: string
  knowledge_points: string
}) {
  return httpRequest.post('/v1/resource/courseware/update', data)
}
// 获取课件详情
export function getCourseDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/courseware/view', { params })
}
// 获取项目列表
export function getProjectList(params: { organization_id: string }) {
  return httpRequest.get('/api/resource/v1/util/members', { params })
}
