import httpRequest from '@/utils/axios'

// 获取学期列表
export function getSemList(params?: { name?: string; organ_id?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/resource/v1/learning/semester/list', { params })
}

// 添加学期
export function addSem(data?: {
  organ_id: string
  name: string
  start_time?: string
  end_time?: string
  length?: string
}) {
  return httpRequest.post('/api/resource/v1/learning/semester/create', data)
}
// 获取学期详情
export function getSemDetail(params?: { id: string }) {
  return httpRequest.get('/api/resource/v1/learning/semester/view', { params })
}
// 更新学期
export function updateSem(data?: {
  id: string
  organ_id: string
  name: string
  start_time?: string
  end_time?: string
  length?: string
}) {
  return httpRequest.post('/api/resource/v1/learning/semester/update', data)
}

// 获取学期中的课程列表
export function getSemCourse(params?: { semester_id: string; name?: string; page?: string; 'per-page'?: string }) {
  return httpRequest.get('/api/resource/v1/learning/semester/courses', { params })
}
// 关联课程-获取课程列表
export function getRelationSemCourse(params?: {
  semester_id: string
  classification?: string
  name?: string
  page?: string
  'per-page'?: string
}) {
  return httpRequest.get('/api/resource/v1/learning/semester/add-courses', { params })
}
// 关联学期-关联/移除学期
export function relationSemCourse(data: { semester_id: string; courses_id: string; type: string }) {
  return httpRequest.post('/api/resource/v1/learning/semester/add-courses', data)
}
// 设置课程别名
export function setAliasName(data: { semester_id: string; course_id: string; alias_name: string }) {
  return httpRequest.post('/api/resource/v1/learning/semester/set-course-alias-name', data)
}
