import httpRequest from '@/utils/axios'

// // 获取学生列表
export function getStaffList(params?: { name?: string; organ_id?: string; page?: string; ['per-page']?: string }) {
  return httpRequest.get('/api/resource/v1/learning/teacher/list', { params })
}
// 添加学生
export function addStaff(data?: {
  school: string
  name: string
  gender: string
  mobile: string
  role: string
  email: string
}) {
  return httpRequest.post('/api/resource/v1/learning/teacher/create', data)
}
// 获取教工详情
export function getStaffDetail(params?: { id: string }) {
  return httpRequest.get('/api/resource/v1/learning/teacher/view', { params })
}
// 更新教工
export function updateStaff(data?: {
  id: string
  school: string
  name: string
  gender: string
  mobile: string
  role: string
  email: string
}) {
  return httpRequest.post('/api/resource/v1/learning/teacher/update', data)
}
