import httpRequest from '@/utils/axios'

// 获取讲师列表

export function getTeacherList(params?: { type?: string; page?: number; ['per-page']?: number }) {
  return httpRequest.get('/api/resource/v1/backend/lecturer/list', { params })
}
// 删除讲师

export function deleteTeacher(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/backend/lecturer/delete', data)
}
// 更新讲师

export function updateTeacher(data: {
  id: string
  name: string
  avatar: string
  status: string
  title: string
  office: string
  education: string
  summarize: string
}) {
  return httpRequest.post('/api/resource/v1/backend/lecturer/update', data)
}
// 创建讲师

export function createTeacher(data: {
  name: string
  avatar: string
  title: string
  status: string
  office: string
  education: string
  summarize: string
}) {
  return httpRequest.post('/api/resource/v1/backend/lecturer/create', data)
}
// 获取讲师详情
export function getTeacherDetail(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/backend/lecturer/view', { params })
}
