import { getCategoryList } from '@/api/base'

export function useGetCategoryList() {
  const list = ref([])
  getCategoryList({ type: 'tree' }).then((res: any) => {
    list.value = res.data.filter((item: any) => {
      if (parseInt(item.status)) {
        item.children = detailChild(item.children)
      }
      return parseInt(item.status)
    })
  })

  const detailChild = (child: any) => {
    if (!child) return []
    return child.filter((item: any) => {
      if (parseInt(item.status)) {
        item.children = detailChild(item.children)
      }
      return parseInt(item.status)
    })
  }
  return { list }
}