import httpRequest from '@/utils/axios'

// 获取试卷列表
export function getPaperList(params?: { course_id?: string; paper_name?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/resource/v1/teaching/paper/paper-list', { params })
}
// 搜索条件
export function getSearchList(params?: { type: string; search_id?: string }) {
  return httpRequest.get('/api/resource/v1/teaching/paper/search-list', { params })
}
// 学员试卷列表
export function getPaperStuList(params?: {
  course_id?: string
  paper_id?: string
  paper_use?: string
  class_id?: string
  student_id?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/resource/v1/teaching/paper/list', { params })
}
// 获取学员详情
export function getPaperStuDetail(params?: { id: string }) {
  return httpRequest.get('/api/resource/v1/teaching/paper/view', { params })
}
// 评分
export function updateComment(data: {
  id: string
  index: string
  child_index?: string
  user_score: string
  reviews: string
}) {
  return httpRequest.post('/api/resource/v1/teaching/paper/update  ', data)
}
// /**
//  * 获取试卷详情
//  */
// export function getPaperDetails(params?: { exam_id: string; student_id: string }) {
//   return httpRequest.get('/api/exam/v1/exam/sheet-detail', { params })
// }
// /**
//  * 批改试卷
//  */
// export function submitPaper(data?: {
//   sheet_id: string
//   question_item_id: string
//   question_id: string
//   score: string
//   comment: string
// }) {
//   return httpRequest.post('/api/exam/v1/exam/submit-sheet', data)
// }
