import httpRequest from '@/utils/axios'

// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/resource/v1/util/info')
}

// 退出登录
export function logout() {
  return httpRequest.get('/api/passport/rest/logout')
}

// 获取oss token
export function getToken() {
  return httpRequest.get('/api/usercenter/aliyun/assume-role')
}

// 获取oss signature
export function getSignature() {
  return httpRequest.get('/api/usercenter/aliyun/get-signature')
}

// 图片上传
export function uploadFile(data: Record<string, any>) {
  return httpRequest
    .post(data.host || 'https://webapp-pub.ezijing.com', data, {
      withCredentials: false,
      headers: { 'Content-Type': 'multipart/form-data' }
    })
    .then(() => data)
}

// 删除评论
export function deleteComment(data: { id: string }) {
  return httpRequest.post('/api/resource/backend/comment/delete', data)
}
// 获取公共字典列表
export function getMapList() {
  return httpRequest.get('/api/resource/v1/util/get-data-dictionary-list')
}

// 上传视频
export function getCreateAuth(data: { title: string; file_name: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/create-auth', data)
}

// 刷新上传视频的地址凭证
export function updateAuth(data: { source_id: string }) {
  return httpRequest.post('/api/resource/v1/resource/video/create-auth', data)
}

// 获取分类列表
export function getCategoryList(params: { type: string; category_name?: string }) {
  return httpRequest.get('/api/resource/v1/backend/category/list', { params })
}

// 获取项目列表
export function getProjectList(params: { organization_id?: string; project_id?: string; semester?: number }) {
  return httpRequest.get('/api/resource/v1/util/members', { params })
}
// 获取试题分类
export function getQuestionCategory(params: { project_tag: string }) {
  return httpRequest.get(`/api/qbs/admin/v2/question-category/tree/${params.project_tag}`, { params })
}

// 获取分片大小和唯一文件名
export function getLocalFileChunk(params: { file_size: number; file_name: string }) {
  return httpRequest.get('/api/lab/v1/common/file/chunk', { params })
}

// 上传每个分片前请求接口来获取当前文件是否超时,之前的分片是否被清理,如果被请求则拒绝处理。返回客户端错误码，让客户端户端不再续传剩余分片
// 1文件被清理 0文件未被清理
export function checkLocalFile(params: { file_name: string }) {
  return httpRequest.get('/api/lab/v1/common/file/check', { params })
}

// 上传文件
export function uploadLocalFile(
  data: { file: File | Blob; file_name: string; is_continuingly?: number; now_package_num: number; total_package_num: number },
  options = {}
) {
  return httpRequest.post(
    '/api/lab/v1/common/file/upload',
    data,
    Object.assign(
      {
        withCredentials: false,
        headers: { 'Content-Type': 'multipart/form-data' }
      },
      options
    )
  )
}
