import axios from 'axios'
import qs from 'qs'
import { Toast } from 'vant'
const httpRequest = axios.create({
  // baseURL: webConf.others.baseUrl,
  timeout: 60000,
  withCredentials: true,
  headers: {
    'Content-Type': 'application/json'
  }
})

// 请求拦截
httpRequest.interceptors.request.use(
  function(config) {
    if (config.headers['Content-Type'] === 'application/x-www-form-urlencoded') {
      config.data = qs.stringify(config.data)
    }
    if (config.headers['Content-Type'] === 'multipart/form-data') {
      const formData = new window.FormData()
      for (const key in config.data) {
        formData.append(key, config.data[key])
      }
      config.data = formData
    }
    return config
  },
  function(error) {
    return Promise.reject(error)
  }
)

// 响应拦截
httpRequest.interceptors.response.use(
  function(response) {
    const { data } = response
    if (data.code) {
      // if (![1010, 1001].includes(data.code)) {
      //   Toast.fail(data.msg || data.message)
      // }
      return Promise.reject(data)
    }
    return data
  },
  function(error) {
    if (error.response) {
      const { status, message } = error.response.data
      // 未登录
      if (status === 403) {
        window.location.href = `${webConf.others.loginUrl}?rd=${encodeURIComponent(window.location.href)}`
      } else {
        Toast.fail(message || error.response.data)
      }
      return Promise.reject(error.response)
    } else {
      console.log(error)
    }
    return Promise.reject(error)
  }
)

export default httpRequest
