import httpRequest from '@/utils/axios'

/**
 * 获取所有店铺
 */
export function getShopList(data) {
  return httpRequest.post('/api/shop/shop/search', data)
}
/**
 * 获取商品列表
 */
export function getGoodsList(data) {
  return httpRequest.post('/api/shop/commodity/spu/search', data)
}
/**
 * 获取商品规格
 */
export function getGoodsSpecs(data) {
  return httpRequest.post('/api/shop/commodity/spu/spec/value/search', data)
}
/**
 * 创建订单
 */
export function createOrder(data) {
  return httpRequest.post('/api/shop/order/add', data)
}