import { getUser, logout } from '@/api/account'
const user = {
  state: {
    user: {},
    isLogin: false
  },

  mutations: {
    setUser(state, user) {
      state.user = user
    },
    setIsLogin(state, isLogin) {
      state.isLogin = isLogin
    }
  },

  actions: {
    // 退出登录
    logout({ commit }) {
      return logout().then(response => {
        commit('setUser', {})
        commit('setIsLogin', false)
        return response
      })
    },
    // 检测登录状态
    async checkLogin({ commit }) {
      // await getUserGrade()
      //   .then(response => {
      //     commit('setUserGrade', response.data.level)
      //   })
      //   .catch(() => {
      //   })
      const isLogin = await getUser()
        .then(response => {
          commit('setUser', response.data)
          return true
        })
        .catch(() => {
          commit('setUser', {})
          return false
        })
      commit('setIsLogin', isLogin)
      return isLogin
    }
  }
}

export default user
