import httpRequest from '@/utils/axios'

// 登出
export function logout() {
  return httpRequest.get('/api/passport/logout')
}
// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/passport/account/get-user-info')
}
// 发送验证码
export function sendCode(data) {
  return httpRequest({
    url: '/api/usercenter/user/send-code',
    method: 'post',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    data
  })
}
// 通过手机号验证码注册并登陆
export function phoneCodeLogin(data) {
  return httpRequest({
    url: '/api/usercenter/user/register-and-login-by-mobile',
    method: 'post',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    data
  })
}
/**
 * 修改用户信息
 */
export function getOpenId(data) {
  return httpRequest({
    url: '/api/usercenter/v1/wechat/get-openid',
    method: 'post',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    data
  })
}