import { getUser, logout } from '@/api/account'
const user = {
  state: {
    user: {},
    isLogin: false,
    isWxBrowser: /micromessenger/i.test(navigator.userAgent) && /android|iphone|ipad|ipod/i.test(navigator.userAgent)
  },

  mutations: {
    setUser(state, user) {
      state.user = user
    },
    setIsLogin(state, isLogin) {
      state.isLogin = isLogin
    }
  },

  actions: {
    // 退出登录
    logout({ commit }) {
      return logout().then(response => {
        commit('setUser', {})
        commit('setIsLogin', false)
        return response
      })
    },
    // 检测登录状态
    async checkLogin({ commit }) {
      // await getUserGrade()
      //   .then(response => {
      //     commit('setUserGrade', response.data.level)
      //   })
      //   .catch(() => {
      //   })
      const isLogin = await getUser()
        .then(res => {
          if (res.code === 0 && res.data && res.data.id) {
            commit('setUser', res.data)
            return true
          } else {
            commit('setUser', {})
            return false
          }
        })
        .catch(() => {
          commit('setUser', {})
          return false
        })
      commit('setIsLogin', isLogin)
      return isLogin
    }
  }
}

export default user
