import Vue from 'vue' // 引入vue框架
import router from './router' // router定义
import store from './store'
import VueI18n from 'vue-i18n' // 使用 国际化
import createI18n from './assets/languages' // 国际化定义
import App from './app.vue' // 初始化 vue页面
import './style.scss' // 公共样式
import './assets/rem/rem.js'
import MetaInfo from 'vue-meta-info'

import createBefore from './utils/beforeEnter'

// vant
import Vant from 'vant'
import 'vant/lib/index.css'

Vue.use(Vant)

Vue.use(VueI18n)
const i18n = createI18n()

Vue.use(MetaInfo)

// Vue.use(modules, { i18n })

/* 设置全局变量 */
window.G = Vue.prototype.$GLOBAL = {
  VERSION: 'PC-1.0.0'
}
/**
 * 定义全局变量 - 用作全局事件发布订阅
 * 使用 vue自带事件 $emit 和 $on 进行发布订阅
 */
Vue.prototype.VueEvent = new Vue()

Vue.prototype.wx = window.wx.miniProgram

/* 创建实例之前，通过导航守卫，处理部分逻辑，如：是否直接进入系统 */
const before = createBefore()
/* 导航守卫 */
router.beforeEach((to, from, next) => {
  before.update(to, from, next)
  // next()
})
window.G.$instance_vue = new Vue({
  store,
  router,
  i18n,
  render: h => h(App)
}).$mount('#app')
