import BaseACTION from './base_action'
import { Other } from '@api'

export default class OtherAction extends BaseACTION {
  /* 获取我的消息信息 */
  getMyMsg (obj) {
    return Other.getMyMsg(obj).then(res => {
      const json = {
        count: res.count,
        countNum: res.un_read_count,
        list: res.list.map(function (_, i) {
          return {
            isRead: false,
            id: _.id,
            text: _.message_body,
            time: _.created_time,
            isShow: _.read_time, // 该字段用来做 每条信息的打开、关闭
            title: _.message_title
          }
        })
      }
      return json
    })
  }

  /**
   * 获取总消息数
   */
  getNavMsg () { return Other.getNavMsg().then(res => res) }
  /**
   * wmp标记已读未读
   */
  setMsgWmp (rid) { return Other.setMsgWmp(rid).then(res => res) }
  /**
   * 设置消息已读未读
   */
  setMyMsg (rid) { return Other.setMyMsg(rid).then(res => res) }
  /**
   * 当前登录用户，检测是否该系统有权限
   */
  getInfo () { return Other.getInfo().then(res => res) }
  examAutoLogin (obj) { return Other.examAutoLogin(obj).then(res => res) }

  /* 调用退出登录接口 */
  outLogin () { return Other.outLogin().then(res => res) }
  /**
   * 文件上传
   */
  uploadFile (obj) { return Other.uploadFile(obj).then(res => res) }
  /**
   * 调用个人信心 - 修改密码
   */
  updatePwd (obj) { return Other.updatePwd(obj).then(res => res) }
  /**
   * 调用个人信息 - 上传头像
   */
  updatePic (obj) { return Other.updatePic(obj).then(res => res) }
}
