import BaseAPI from '@/api/base_api'
const httpRequest = new BaseAPI(webConf)

/**
 * 获取课程详情
 * @param {string} courseId 课程ID
 * @param {string} semesterId 学期ID
 */
export function getCourse(courseId, semesterId) {
  return httpRequest.get(`/v2/education/courses/${courseId}/${semesterId}`)
}

/**
 * 获取章节资源详情
 * @param {string} vid 资源ID
 */
export function getChapterVideo(vid) {
  return httpRequest.post(
    '/v2/education/video-streaming',
    { vid },
    { headers: { 'Content-Type': 'application/json' } }
  )
}

/**
 * 获取章节资源详情
 * @param {string} vid 章节的资源ID
 */
export function getChapterVideoAliyun(vid) {
  return httpRequest.post(
    '/v2/education/aliyun-video-streaming',
    { vid },
    { headers: { 'Content-Type': 'application/json' } }
  )
}
