import BaseAPI from './base_api'

export default class CourseAPI extends BaseAPI {
  /**
   * 获取学期分类信息
   */
  getLearnFind = () => this.get('/v2/education/semesters', {})
  /**
   * 获取所有课程列表 - 选课广场 和 我的课程 共用同一个,通过 isMy判断
   * @param {[string]} isMy
   * @param {[object]} param
   */
  getCourseList = (isMy, param) => this.get('/v2/education/courses' + (isMy ? '/my' : ''), param)
  /**
   * 获取某个课程详细信息 - 课程考核 和 课程讨论单独获取
   * @param {[string]} id
   * @param {[string]} sid
   */
  getCourseDetail = (id, sid) => this.get(`/v2/education/courses/${sid}/${id}`, {})
  /**
   * 获取课程考核信息
   * @param {[string]} cid
   * @param {[string]} sid
   */
  getCourseAssess = (cid, sid) => this.get(`/v2/analytics/courses/${sid}/${cid}/evaluation`, {})
  /**
   * 选课
   * @param {[string]} cid
   * @param {[string]} sid
   */
  selectCourse = (cid, sid) => this.post('/v2/education/courses/major', { course_id: cid, semester_id: sid })
  /**
   * 退课
   * @param {[string]} cid
   * @param {[string]} sid
   */
  outSelectCourse = (cid, sid) => this.post('/v2/education/courses/drop', { course_id: cid, semester_id: sid })
}
