import BaseAPI from '@/api/base_api'

const httpRequest = new BaseAPI(webConf)

/**
 * 获取课程详情
 * @param {string} semesterId 学期ID
 * @param {string} courseId 课程ID
 */
export function getCourse(semesterId, courseId) {
  return httpRequest.get(`/api/lms/v3/education/courses/${semesterId}/${courseId}`)
}

/**
 * 课程考核
 * @param {string} semesterId 学期ID
 * @param {string} courseId 课程ID
 */
export function getCourseAssess(semesterId, courseId) {
  return httpRequest.get(`/api/lms/v2/analytics/courses/${semesterId}/${courseId}/evaluation`).then(res => {
    // 视频数据组装
    let videoList = Object.values(res.video_evaluation)
    videoList = videoList.map(item => {
      item.sections = Object.values(item.sections)
      return item
    })
    res.video_evaluation = videoList
    // 作业数据组装
    let homeworkList = Object.values(res.homework_evaluation)
    homeworkList = homeworkList.map(item => {
      item.sections = Object.values(item.sections)
      return item
    })
    res.homework_evaluation = homeworkList
    return res
  })
}
