import { uploadFile } from '@/api/common'

export default class MyUploadAdapter {
  constructor(loader) {
    // The file loader instance to use during the upload.
    this.loader = loader
  }

  // Starts the upload process.
  upload() {
    return this.loader.file.then(
      file =>
        new Promise((resolve, reject) => {
          this._sendRequest(resolve, reject, file)
        })
    )
  }

  _sendRequest(resolve, reject, file) {
    uploadFile({ file })
      .then(response => {
        if (response.success) {
          resolve({ default: response.url })
        } else {
          return reject(response.message)
        }
      })
      .catch(response => {
        return reject(response.message)
      })
  }
}
