import BaseAPI from '@/api/base_api'
const httpRequest = new BaseAPI(webConf)

/**
 * 获取课程讨论列表
 */
export const getDiscussList = (param) => {
  const paramPath = param.path || ''
  return httpRequest.get(
    `/v2/qa/questions${paramPath}`,
    param.dataJson
  )
}
/**
 * 获取我的课程讨论列表
 */
export const getCourseDiscussList = (param) => {
  const paramPath = param.path || ''
  return httpRequest.get(
    `/v2/qa/questions/course${paramPath}`,
    param.dataJson
  )
}
/**
 * 删除提问
 */
export const deleteDiscuss = (qid) => {
  return httpRequest.delete(
    `/v2/qa/questions/${qid}`
  )
}

/**
 * 获取问题详情
 */
export const getDiscussDetail = (qid) => {
  return httpRequest.get(
    `/v2/qa/questions/${qid}`
  )
}
/**
 * 删除评论
 */
export const deleteComment = (cid) => {
  return httpRequest.delete(
    `/v2/qa/comments/${cid}`
  )
}
/**
 * 回复评论
 */
export const callbackComment = (param) => {
  return httpRequest.post(
    '/v2/qa/comments',
    param,
    { headers: { 'Content-Type': 'application/json' } }
  )
}
