/**
 * 本文件执行，需要 node -v >= v8.11.3
 * 原因：其中使用很多es6新特性，需要高版本才能直接识别并运行
 * 放服务器上 上传慢，而且经常报错（没找到原因），最后改为打包完成后自动上传不在服务器上deploy时再上传了
 */
const fs = require('fs')
const path = require('path')

// 这个包本身也是用es6语法写的，低版本node编译解析不了
const OSS = require('ali-oss')

const conf = require('./config')

const client = new OSS({
  region: 'oss-cn-beijing',
  accessKeyId: 'LTAIOTuuLTaWoGJj',
  accessKeySecret: 'dE5tTGm2lh35eItct2krW2DeH2lf2I',
  bucket: 'zws-imgs-pub'
})

/* 定位到对应 public目录下 */
const DIR_PATH = path.join(__dirname, '../' + conf.DesDir)
/* 上传对应目录 */
const PREFIX_PATH = conf.CDN_DIR
/* 是否上传static目录 */
const isUploadStatic = conf.isUploadStatic

let fileCount = 1
/**
 * 调用接口，单个文件上传
 * @param {string} dirPath 传入对应需要遍历的路径
 * @param {function} callback 加入一个回调方法，执行文件上传
 */
async function uploadFile (prefixPath, dirFileName) {
  try {
    const upFilePath = prefixPath.replace(new RegExp(DIR_PATH, 'gi'), '') + path.basename(dirFileName)
    let result = await client.put(prefixPath + path.basename(dirFileName), dirFileName)
    if (result.res.status === 200) {
      console.log('第' + fileCount++ + '个文件，已上传：' + conf.CDN_BASE + upFilePath)
      return { status: 200 }
    }
  } catch (err) {
    console.log('第' + fileCount++ + '个文件，上传失败：' + conf.CDN_BASE + upFilePath)
    return { status: 500, err: err }
  }
}

/**
 * 循环遍历文件，准备上传文件
 * 原生js 遍历方法
 * @param {string} dirPath 传入对应需要遍历的路径
 * @param {function} callback 加入一个回调方法，执行文件上传
 */
function uploadfiles (dirPath, callback) {
  /* 根据文件路径读取文件 */
  const files = fs.readdirSync(dirPath)
  files.forEach(function (filename, i) {
    const filedir = path.join(dirPath, filename)
    const info = fs.statSync(filedir)
    if (info.isDirectory()) {
      /* 确定是否上传 */
      if (!(isUploadStatic ? true : filename !== 'static')) { return }
      /* 得到对应目录结构 */
      const morePath = filedir.replace(new RegExp(DIR_PATH, 'gi'), '') + '/'
      /* 递归，如果是文件夹，就继续遍历该文件夹下面的文件 */
      uploadfiles(filedir, function (filedir) {
        uploadFile(path.join(PREFIX_PATH, morePath), filedir)
      })
    } else {
      if (typeof callback === 'function') {
        callback(filedir)
      } else {
        uploadFile(PREFIX_PATH, filedir)
      }
    }
  })
  return true
}

/* 批量上传文件 */
uploadfiles(DIR_PATH, null)
