(function (window) {
  var sentNotify = function (title, content, icon) {
    var Notification = window.Notification || window.mozNotification || window.webkitNotification
    if (!Notification) {
      window.alert('您的浏览器不支持此特性，推荐使用chrome浏览器')
      return false
    }
    var options = {
      body: content,
      icon: icon || ''
    }
    // 需要 - 进行相关操作、或提示开启
    window.Notification.requestPermission(function (status) {
      if (status === 'granted') {
        // 推送功能为开启状态(用户点击允许后的状态)
        var instance = new Notification(title, options)

        instance.onclick = function () {
          instance.close()
        }
        instance.onerror = function () {}
        instance.onshow = function () {
          setTimeout(function () {
            instance.close()
          }, 3000)
          console.log(instance.body)
        }
        instance.onclose = function () {}
      } else if (status === 'denied') {
        // 用户点击了禁用(拒绝打开推送功能) (也有可能是非HTTPS)
        window.alert('您的针对改网站已经关闭消息推送，重新开启请打开设置。')
        return false
      } else {
        // 用户已经忽略选择
        return false
      }
    })
  }

  window.sentNotify = sentNotify
})(this)
