import Vue from 'vue' // 引入vue框架
import Element from 'element-ui' // 引入 element-ui 框架
import './components/style/_com.scss' // 定义 element-ui主题色 + 公共样式
import VueRouter from 'vue-router' // 使用 vue-router
import createRouter from './router' // router定义
import Main from './main.vue' // 初始化 vue页面
// import cTool from '@tools'
/* 引入 md5 */
import md5 from 'js-md5'

/* 定义全局变量 */
import BeforeRouter from './components/before'

/* 兼容处理 start */
/* 处理低版本浏览器支持axiosfinally问题 */
require('promise.prototype.finally').shim()
/* 兼容处理 end */

Vue.use(Element)
Vue.use(VueRouter)
const router = createRouter()
/* 设置全局变量 */
window.G = Vue.prototype.$GlobalVariable = {
  VERSION: 'PC-1.1.0'
}
Vue.prototype.$md5 = md5
/* 导航守卫 */
router.beforeEach((to, from, next) => {
  /* 设置 全局变量 */
  BeforeRouter.globalVariable.init(Vue, { to, from, next })
  if (to.name !== 'normalLogin' && to.name !== 'codeLogin' && to.name !== 'forgetPwd') { // 所有登录页 不进行登录校验
    BeforeRouter.loginInfo.isLogin(Vue).then(str => {
      if (/^login/gi.test(str)) {
        next()
      } else {
        next({ path: '/login/index?rd=' + encodeURIComponent(to.fullPath) }) // 需要传参并再传回来
      }
    }).catch(e => {
      // /* 重新登录，清空cookie 和 本地登录账号信息 */
      // cTool.cookies.clearCookie('_SUP', { path: '/', domain: '.ezijing.com', expires: '' })
      window.G.UserInfo = {}
      next({ path: '/login/index?rd=' + encodeURIComponent(to.fullPath) }) // 需要传参并再传回来
    })
  } else if ((to.name === 'normalLogin' && !!to.query.rd) || (to.name === 'codeLogin' && !!to.query.rd)) {
    BeforeRouter.loginInfo.isLogin(Vue).then(str => {
      if (/^login-2/gi.test(str)) {
        next({ path: to.query.rd })
      } else {
        next()
      }
    }).catch(e => { next() })
  } else {
    next()
  }
})
/**
 * 定义全局变量 - 用作全局事件发布订阅
 * 使用 vue自带事件 $emit 和 $on 进行发布订阅
 */
Vue.prototype.VueEvent = new Vue()

// /* 定义全局 jquery 变量 */
// Vue.prototype.jq = $

new Vue({
  router,
  render: (h) => h(Main)
}).$mount('#app')
