const express = require('express')
const history = require('connect-history-api-fallback')
const path = require('path')
const app = express()

app.set('port', process.env.SERVER_PORT || 3000)

app.use('/', require('./routes'))

app.use(history({ verbose: false, index: '/' }))
app.get('/', (req, res) => {
  /* 增加 限定条件，如果是 e-learning2 子域名，那么 referer 为指定 域名 否则不能打开 */
  if (/^e-learning2\./.test(req.headers.host)) {
    if (/(sofia\.tenant\.ezijing)|(sofia-x\.ezijing)|(course\.ezijing)/.test(req.headers.referer)) {
      res.sendFile(path.join(__dirname, '../client-dist/index.html'))
    } else {
      res.send('当前页面打开方式不对')
    }
  } else {
    res.sendFile(path.join(__dirname, '../client-dist/index.html'))
  }
})
app.use(express.static(path.join(__dirname, '../client-dist')))

app.set('trust proxy', true)
/* 开启服务 */
global.SocketServer = app.listen(app.get('port'), function () {
  console.log('Express server 🌎  listening on：http://localhost:' + app.get('port'))
})
