import BaseAPI from './base_api'

export default class DiscussAPI extends BaseAPI {
  /**
   * 获取讨论题目列表，“我提出的问题”和“我参与的问题”信息
   * dataJson.limit - 获取数量
   * dataJson.offset - 偏移量
   * @param {[string]} path
   * @param {[object]} dataJson
   */
  getDiscussList = (path, dataJson) => this.get('/v2/qa/questions' + path, dataJson)
  /**
   * 获取讨论题目列表，“课程的问题”信息
   * dataJson.limit - 获取数量
   * dataJson.offset - 偏移量
   * dataJson.sort - 排序类型
   * @param {[string]} cid
   * @param {[object]} dataJson
   */
  getCourseDiscussList = (cid, sid, dataJson) => this.get(`/v2/qa/questions/course/${cid}`, dataJson)
  /**
   * 获取问题详情
   * @param {[string]} qid
   */
  getDiscussDetail = (qid) => this.get(`/v2/qa/questions/${qid}`, {})
  /**
   * 删除提问
   * @param {[string]} qid
   */
  deleteDiscuss = (qid) => this.delete(`/v2/qa/questions/${qid}`, {})
  /**
   * 提出问题
   * @param {[object]} param
   */
  publishQues = (param) => this.post('/v2/qa/questions', param, { headers: { 'Content-Type': 'multipart/form-data' } })
  /**
   * 回答问题
   * @param {[object]} param
   */
  answerQues = (param) => this.post('/v2/qa/answers', param, { headers: { 'Content-Type': 'application/json' } })
  /**
   * 删除回答
   * @param {[string]} aid
   */
  deleteAnswer = (aid) => this.delete(`/v2/qa/answers/${aid}`, {})
  /**
   * 回复评论
   * @param {[object]} param
   */
  callbackComment = (param) => this.post('/v2/qa/comments', param, { headers: { 'Content-Type': 'application/json' } })
  /**
   * 删除评论
   * @param {[string]} cid
   */
  deleteComment = (cid) => this.delete(`/v2/qa/comments/${cid}`)
  /**
   * 点赞
   * @param {[object]} param
   */
  like = (param) => this.post('/v2/qa/tags', param, { headers: { 'Content-Type': 'application/json' } })
  /**
   * 取消点赞
   * @param {[string]} tagid
   */
  unlike = (tagid) => this.delete(`/v2/qa/tags/${tagid}`, {})
}
