/**
 * 侧边章节导航列表
 * props:
 *      chapters []
 *      getProgressByChapterId func
 *      courseId
 *      chapterId string
 *      progress number
 */
import React, { Component } from 'react'
import { Link } from 'react-router';
import ProgressCircle from '../../components/ProgressCircle.jsx'
import {chapterType} from '../../libs/const'

const NAV_COURSE = {
    name: '大作业及资料',
    children: [{
        id: 'work',
        type: chapterType.WORKOREXAM,
        name: '课程大作业',
        homework: {work_type: chapterType.WORK_HOME}
    }, {
        id: 'info',
        type: chapterType.READ,
        name: '课程资料'
    }]
};

class SideList extends Component {

    reloadPages () {
        window.location.reload()
    }

    render () {
        const {chapters, getProgressByChapterId, semesterId, courseId, chapterId, progress} = this.props;
        let list = (chapters || []).concat([NAV_COURSE]);

        return (
            <div className="tab-pane current">
                <ul className="under-control chapter-list current">
                    {list.map((item, index) => {
                        return (
                            <li className="chapter-item" key={index}>
                                <span className="cpt">{item.name}</span>
                                <div className="knob-list-wrap">
                                    <ul className="knob-list">
                                        {(item.children || []).map((o, i) => {
                                            let isCur = chapterId === o.id;
                                            let prog = isCur ? progress : getProgressByChapterId(o.id);
                                            let part = Math.max(Math.round(prog / 25), 0);
                                            let type;
                                            switch (o.type) {
                                                case chapterType.VIDEO:
                                                    type = 'video'; break;
                                                case chapterType.READ:
                                                    type = 'read'; break;
                                                default:
                                                    type = 'exam';
                                                    if (o.homework && o.homework.work_type === chapterType.WORK_HOME) {
                                                        type = 'work';
                                                    }
                                            }
                                            return (
                                                <li className={`knob-item ${isCur ? 'current' : ''} ${part ? ['one', 'two', 'three', 'four'][part - 1] + '-four' : ''}`} key={i}>
                                                    <ProgressCircle percent={prog} className="play-chapter-progress"/>
                                                    <i className="icon icon-pro" title={`学习进度 ${prog}%`}></i>
                                                    {(type == 'work') ?
                                                        <Link to={`/courses/${semesterId}/${courseId}/chapters/${o.id}`} className="knob-name" onClick={this.reloadPages}>{o.name}</Link>                                                        
                                                        : 
                                                        <Link to={`/courses/${semesterId}/${courseId}/chapters/${o.id}`} className="knob-name" onClick={this.props.handleClickItem}>{o.name}</Link>
                                                    }
                                                    <i className={`icon-play-chapter icon-play-${type}`}></i>
                                                </li>
                                            );
                                        })}
                                    </ul>
                                </div>
                            </li>
                        );
                    })}

                </ul>
            </div>
        );
    }
}

module.exports = SideList;
