import BaseAPI from '../base_api'

export default class ChapterAPI extends BaseAPI {
  /**
   * 获取章节列表信息
   * @param {[string]} cur_course_id -> cid
   * @param {[string]} cur_semester_id -> sid
   * @param {[string]} cur_video_id -> vid
   */
  getChapterList = (cid, sid, vid) => this.get(`/tenant/v2/education/courses/${sid}/${cid}`, {})
  /**
   * 获取对应某个章节的详细信息
   * @param {[string]} vid
   */
  getCurrentChapterDetail = (vid) => this.post('/tenant/v2/education/video-streaming', { vid })
  /**
   * 获取进度信息
   * @param {[string]} vid
   * @param {[string]} did
   * @param {[string]} sid
   */
  getProgress = (vid, did, sid) => this.get(`/v2/education/video/${sid}/${vid}/device`, { device_id: did })
  /**
   * 提交进度信息
   * @param {[object]} obj
   */
  updateProgress = (obj = {}) => this.post('/v2/analytics/upload-video', {
    d: obj.did,
    i: obj.did,
    c: obj.cid,
    s: obj.sid,
    v: obj.vid,
    _p: obj.pt, // 累计时间
    _m: obj.mpt, // 当前播放最大时间
    _c: obj.cpt // 当前播放位置
  })
  /**
   * 获取对应 作业或问题 回答
   * @param {[string]} sid
   * @param {[string]} id resource_id
   */
  getHomework = (sid, id) => this.get(`/tenant/v2/education/homeworks/${sid}/${id}`, {})
  /**
   * 文件提交
   * @param {[object]} obj
   */
  uploadFile = (obj = {}) => this.post('/tenant/util/upload-file', obj, { headers: { 'Content-Type': 'multipart/form-data' } })
  /**
   * 提交课程 作业或问题
   */
  updateHomework = (obj = {}) => this.post('/tenant/v2/education/homeworks', obj, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 获取对应 大作业 回答
   * @param {[string]} sid
   * @param {[string]} cid
   */
  getCourseHomework = (sid, cid) => this.get(`/tenant/v2/education/courses/${sid}/${cid}/essay`, {})
  /**
   * 提交课程 大作业
   * @param {[string]} sid
   * @param {[string]} cid
   */
  updateCourseHomework = (sid, cid, obj = {}) => this.post(`/tenant/v2/education/courses/${sid}/${cid}/essay`, obj, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
}
