import { discussApi } from '@services'

/**
 * 小程序 跟 PC 区别
 * 1. PC 直接使用 then，小程序 需要 callback
 * 2. PC 直接返回 对象，小程序 外层再保证一次返回 { status: xxx, data: data }
 */

export default class DiscussAction {
  /* 获取讨论题目列表，“我提出的问题”和“我参与的问题”信息 */
  /**
   * dataJson.limit - 获取数量
   * dataJson.offset - 偏移量
   */
  getDiscussList (path, dataJson) {
    return discussApi.getDiscussList(path, dataJson).then(res => {
      let _data = res
      let json = _data.map(function (_, i) {
        return {
          id: _.id,
          sid: _.semester_id,
          user: {
            url: _.questioner.avatar || '',
            name: _.questioner.nickname,
            time: _.created_time
          },
          title: _.title,
          text: _.contents,
          askCnt: _.answer_count,
          TouCnt: _.tag_total_count,
          courseName: '在线学习课程',
          comments: _.comments,
          mine: _.mine,
          isShow: false
        }
      })
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 获取讨论题目列表，“课程的问题”信息 */
  /**
   * dataJson.limit - 获取数量
   * dataJson.offset - 偏移量
   * dataJson.sort - 排序类型
   */
  getCourseDiscussList (cid, sid, dataJson) {
    return discussApi.getCourseDiscussList(cid, sid, dataJson).then(res => {
      let _data = res
      let json = _data.map(function (_, i) {
        return {
          id: _.id,
          sid: _.semester_id,
          user: {
            url: _.questioner.avatar || '',
            name: _.questioner.nickname,
            time: _.created_time
          },
          title: _.title,
          text: _.contents,
          askCnt: _.answer_count,
          TouCnt: _.tag_total_count,
          courseName: '在线学习课程',
          comments: _.comments,
          mine: _.mine,
          isShow: false
        }
      })
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 获取问题详情 */
  getDiscussDetail (qid, callback) {
    return discussApi.getDiscussDetail(qid).then(res => {
      let _data = res.data
      let json = {
        ques: {
          qid: _data.id,
          sid: _data.semester_id,
          user: {
            url: _data.questioner.avatar || '',
            name: _data.questioner.nickname,
            time: _data.created_time
          },
          title: _data.title,
          text: _data.contents,
          askCnt: _data.answer_count || 0,
          TouCnt: _data.tag_total_count || 0,
          likeCnt: _data.tag_count || 0,
          comCnt: _data.comments.length,
          mine: _data.mine,
          isShowComment: false,
          has_tag: _data.has_tag,
          tag_id: (_data.tag && _data.tag.id) || '',
          comments: _data.comments.map(function (_, i) {
            return {
              cid: _.id,
              user: {
                url: _.observer.avatar || '',
                name: _.observer.nickname,
                time: _.created_time
              },
              text: _.comments,
              mine: _.mine
            }
          })
        },
        answer: (_data.answers && _data.answers.map(function (_, i) {
          return {
            aid: _.id,
            user: {
              url: _.replier.avatar || '',
              name: _.replier.nickname,
              time: _.created_time
            },
            text: _.contents,
            likeCnt: _.tag_count,
            comCnt: _.comments.length,
            mine: _.mine,
            isShowComment: false,
            has_tag: _.has_tag,
            tag_id: (_.tag && _.tag.id) || '',
            comments: _.comments.map(function (__, i) {
              return {
                cid: __.id,
                user: {
                  url: __.observer.avatar || '',
                  name: __.observer.nickname,
                  time: __.created_time
                },
                text: __.comments,
                mine: __.mine
              }
            })
          }
        })) || []
      }
      // callback(json) // 可以不使用callback 因为使用then
      return json
    })
  }
  /* 删除提问 */
  deleteDiscuss (qid, callback) {
    return discussApi.deleteDiscuss(qid).then(res => {
      let _data = res.data
      if (_data.success) {
        // callback(res) // 可以不使用callback 因为使用then
        return res
      }
    })
  }
  /* 提出问题 */
  publishQues (param) {
    return discussApi.publishQues(param).then(res => {
      // callback(res) // 可以不使用callback 因为使用then
      return res
    })
  }
  /* 回答问题 */
  answerQues (param, callback) {
    return discussApi.answerQues(param).then(res => {
      let _data = res.data
      if (_data.success) {
        // callback(res) // 可以不使用callback 因为使用then
        return res
      }
    })
  }
  /* 删除回答 */
  deleteAnswer (aid, callback) {
    return discussApi.deleteAnswer(aid).then(res => {
      let _data = res.data
      if (_data.success) {
        // callback(res) // 可以不使用callback 因为使用then
        return res
      }
    })
  }
  /* 回复评论 */
  callbackComment (param, callback) {
    return discussApi.callbackComment(param).then(res => {
      let _data = res.data
      if (_data.success) {
        // callback(res) // 可以不使用callback 因为使用then
        return res
      }
    })
  }
  /* 删除评论 */
  deleteComment (cid, callback) {
    return discussApi.deleteComment(cid).then(res => {
      let _data = res.data
      if (_data.success) {
        // callback(res) // 可以不使用callback 因为使用then
        return res
      }
    })
  }
  /* 点赞 */
  like (param, callback) {
    return discussApi.like(param).then(res => {
      let _data = res.data
      if (_data.success) {
        // callback(res) // 可以不使用callback 因为使用then
        return res
      }
    })
  }
  /* 取消点赞 */
  unlike (tagid, callback) {
    return discussApi.unlike(tagid).then(res => {
      let _data = res.data
      if (_data.success) {
        // callback(res) // 可以不使用callback 因为使用then
        return res
      }
    })
  }
}
