import App from '../app.vue'
import container from '../components/layout/container.vue'

export default [
  { path: '/', redirect: '/login' },
  {
    path: '/login',
    redirect: '/login/index',
    component: () => import('../../../components/login/login.vue'),
    children: [
      {
        path: 'index',
        name: 'normalLogin',
        component: () => import('../../../components/login/normal/normal.vue'),
        props: (route) => ({ query: route.query, params: route.params })
      },
      {
        path: 'code',
        name: 'codeLogin',
        component: () => import('../../../components/login/code/code.vue'),
        props: (route) => ({ query: route.query, params: route.params })
      },
      {
        path: 'forget',
        name: 'forgetPwd',
        component: () => import('../../../components/login/forget/forget.vue'),
        props: (route) => ({ query: route.query, params: route.params })
      }
    ]
  },
  /* App 内登录页面未找到时 - 指向 */
  { path: '/login/*', redirect: '/login/index' },
  {
    path: '/app',
    redirect: '/app/error/404',
    component: App,
    children: [
      { path: 'error/404', component: () => import('../components/error/404.vue') },
      {
        path: 'my-learn',
        redirect: 'error/404',
        component: container,
        children: [
          { path: 'course', component: () => import('../pages/myLearn/course.vue') },
          { path: 'course-detail/:sid/:cid', component: () => import('../pages/myLearn/courseDetail.vue'), props: true },
          { path: 'course-all', component: () => import('../pages/myLearn/courseAll.vue') },
          { path: 'discussion', component: () => import('../pages/myLearn/discussion.vue') },
          { path: 'report', component: () => import('../pages/myLearn/report.vue') }
        ]
      },
      {
        path: 'my-grade',
        redirect: 'error/404',
        component: container,
        children: [
          { path: 'credit', component: () => import('../pages/myGrade/credit.vue') }
        ]
      },
      {
        path: 'account',
        redirect: 'error/404',
        component: container,
        children: [
          { path: 'set-pwd', component: () => import('../pages/account/setPwd.vue') },
          { path: 'update-pic', component: () => import('../pages/account/updatePic.vue') }
        ]
      }
    ]
  },
  /* App 内未找到页面时 - 指向 */
  { path: '/app/*', redirect: '/app/error/404' },
  {
    path: '/player/:sid/:cid',
    redirect: '/player/0/0/error/404',
    component: () => import('../../../components/player/index.vue'),
    props: true,
    children: [
      { path: 'error/404', component: () => import('../components/error/404.vue') },
      {
        path: 'chapter-video/:id',
        name: 'chapterVideo',
        component: () => import('../../../components/player/chapterVideo/chapterVideo.vue'),
        props: true
      },
      {
        path: 'chapter-exam/:id',
        name: 'chapterExam',
        component: () => import('../../../components/player/chapterExam/chapterExam.vue'),
        props: true
      },
      {
        path: 'chapter-read/:id',
        name: 'chapterRead',
        component: () => import('../../../components/player/chapterRead/chapterRead.vue'),
        props: true
      },
      {
        path: 'chapter-work/:id',
        name: 'chapterWork',
        component: () => import('../../../components/player/chapterWork/chapterWork.vue'),
        props: true
      },
      {
        path: 'course-info/:id',
        name: 'courseInfo',
        component: () => import('../../../components/player/courseInfo/courseInfo.vue'),
        props: true
      },
      {
        path: 'course-work/:id',
        name: 'courseWork',
        component: () => import('../../../components/player/courseWork/courseWork.vue'),
        props: true
      }
    ]
  },
  /* App 内登录页面未找到时 - 指向 */
  { path: '/player/*', redirect: '/player/0/0/error/404' },
  /* 如果所有页面都没找到 - 指向 */
  { path: '*', component: () => import('../components/error/404.vue') }
]
