import BaseAPI from '../base_api'

export default class ScoreAPI extends BaseAPI {
  /**
   * 获取所有通过报告列表
   */
  getReportList = () => this.get('/v2/education/symposium-report-all', {})
  /**
   * 获取我的学术活动
   */
  getReportActiveList = () => this.get('/v2/education/symposium/my', {})
  /**
   * 提交活动申请
   * symposium_name 活动名称
   * symposium_time 活动时间
   * symposium_lecturer 活动讲师
   * symposium_contents 活动内容
   * symposium_attachments 活动附件
   * symposium_address 活动地点
   * 返回 {'flag' : true, 'errors' : []}
   */
  submitReportActive = (obj = {}) => this.post('/v2/education/symposium', obj, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  /**
   * 获取学术活动详情
   */
  getReportActive = (rid) => this.get(`/v2/education/symposium/${rid}`, {})
  /**
   * 修改活动申请
   * 参数同上
   */
  updateReportActive = (rid, obj = {}) => this.post(`/v2/education/symposium/${rid}`, obj)
  /**
   * 删除活动申请
   * 参数同上
   */
  deleteReportActive = rid => this.delete(`/v2/education/symposium/${rid}`, {})
  /**
   * 获取活动相关的学术报告
   */
  getReportListAll = (rid) => this.get(`/v2/education/symposium/${rid}/report`, {})
  /**
   * 提交学术报告
   * report_name 报告名称
   * report_description 报告描述
   * file_url 文章URL
   */
  submitReport = (rid, obj = {}) => this.post(`/v2/education/symposium/${rid}/report`, obj)
  /**
   * 获取学术报告详情
   */
  getSubmitReport = (rid, reid) => this.get(`/v2/education/symposium/report/${reid}`, {})
  /**
   * 更新学术报告
   */
  updateSubmitReport = (rid, reid, obj = {}) => this.post(`/v2/education/symposium/${rid}/report/${reid}`, obj)
  /**
   * 删除学术报告
   * 参数同上
   */
  deleteSubmitReport = (rid, reid) => this.delete(`/v2/education/symposium/report/${reid}`, {})
  /**
   * 获取事务类型
   */
  getAffairsType = () => this.get('/v2/lobby/affairs')
  /**
   * 获取事务类型
   */
  getAffairsData = (obj = {}) => this.get('/v2/lobby/processes', obj)
  /**
   * 提交活动申请
   * affair_id 活动名称
   * symposium_name 活动时间
   * symposium_contents 活动讲师
   * symposium_attachments 活动内容
   * symposium_time 活动附件
   * symposium_address 活动地点
   * symposium_lecturer
   * 返回 {'flag' : true, 'errors' : []}
   */
  submitLearning = (obj = {}) => this.post('/v2/lobby/processes', obj)
  /* 删除事务 */
  deleteAffairs = (reid) => this.delete(`/v2/lobby/processes/${reid}`, {})
  /* 获取事务详情 */
  getAffairsDetails = (rid) => this.get(`/v2/lobby/processes/${rid}`, {})
  /* 修改事务 */
  updateAffairs = (rid, obj = {}) => this.post(`/v2/lobby/processes/${rid}`, obj)
  /* 重修图片提交 */
  uploadFile = (obj = {}) => this.post('/v2/lobby/tools/upload', obj, { headers: { 'Content-Type': 'multipart/form-data' } })
}
