const express = require('express')
const history = require('connect-history-api-fallback')
const path = require('path')

const app = express()

app.set('port', process.env.SERVER_PORT || 3000)

app.use('/', require('./routes'))

app.use(history({ verbose: false, index: '/' }))
app.get('/', (req, res) => { res.sendFile(path.join(__dirname, '../client-dist/index.html')) })
app.use(express.static(path.join(__dirname, '../client-dist')))

app.set('trust proxy', true)
/* 开启服务 */
app.listen(app.get('port'), function () {
  console.log('Express server 🌎  listening on：http://localhost:' + app.get('port'))
})
